###########################################################
#
# libesmtp-nothread
#
###########################################################
#
# LIBESMTP_NOTHREAD_VERSION, LIBESMTP_NOTHREAD_SITE and LIBESMTP_NOTHREAD_SOURCE define
# the upstream location of the source code for the package.
# LIBESMTP_NOTHREAD_DIR is the directory which is created when the source
# archive is unpacked.
# LIBESMTP_NOTHREAD_UNZIP is the command used to unzip the source.
# It is usually "zcat" (for .gz) or "bzcat" (for .bz2)
#
# You should change all these variables to suit your package.
# Please make sure that you add a description, and that you
# list all your packages' dependencies, seperated by commas.
# 
# If you list yourself as MAINTAINER, please give a valid email
# address, and indicate your irc nick if it cannot be easily deduced
# from your name or email address.  If you leave MAINTAINER set to
# "NSLU2 Linux" other developers will feel free to edit.
#
LIBESMTP_NOTHREAD_SITE=http://www.stafford.uklinux.net/libesmtp
LIBESMTP_NOTHREAD_VERSION=1.0.4
LIBESMTP_NOTHREAD_SOURCE=libesmtp-$(LIBESMTP_NOTHREAD_VERSION).tar.bz2
LIBESMTP_NOTHREAD_DIR=libesmtp-$(LIBESMTP_NOTHREAD_VERSION)
LIBESMTP_NOTHREAD_UNZIP=bzcat
LIBESMTP_NOTHREAD_MAINTAINER=NSLU2 Linux <nslu2-linux@yahoogroups.com>
LIBESMTP_NOTHREAD_DESCRIPTION=libESMTP is a library to manage posting electronic mail using SMTP to a preconfigured Mail Transport Agent (MTA).
LIBESMTP_NOTHREAD_SECTION=mail
LIBESMTP_NOTHREAD_PRIORITY=optional
LIBESMTP_NOTHREAD_DEPENDS=
LIBESMTP_NOTHREAD_SUGGESTS=
LIBESMTP_NOTHREAD_CONFLICTS=

#
# LIBESMTP_NOTHREAD_IPK_VERSION should be incremented when the ipk changes.
#
LIBESMTP_NOTHREAD_IPK_VERSION=2

#
# LIBESMTP_NOTHREAD_CONFFILES should be a list of user-editable files
#LIBESMTP_NOTHREAD_CONFFILES=/opt/etc/libesmtp-nothread.conf /opt/etc/init.d/SXXlibesmtp-nothread

#
# LIBESMTP_NOTHREAD_PATCHES should list any patches, in the the order in
# which they should be applied to the source code.
#
#LIBESMTP_NOTHREAD_PATCHES=$(LIBESMTP_NOTHREAD_SOURCE_DIR)/nothread.patch

#
# If the compilation of the package requires additional
# compilation or linking flags, then list them here.
#
LIBESMTP_NOTHREAD_CPPFLAGS=
LIBESMTP_NOTHREAD_LDFLAGS=

#
# LIBESMTP_NOTHREAD_BUILD_DIR is the directory in which the build is done.
# LIBESMTP_NOTHREAD_SOURCE_DIR is the directory which holds all the
# patches and ipkg control files.
# LIBESMTP_NOTHREAD_IPK_DIR is the directory in which the ipk is built.
# LIBESMTP_NOTHREAD_IPK is the name of the resulting ipk files.
#
# You should not change any of these variables.
#
LIBESMTP_NOTHREAD_BUILD_DIR=$(BUILD_DIR)/libesmtp-nothread
LIBESMTP_NOTHREAD_SOURCE_DIR=$(SOURCE_DIR)/libesmtp-nothread
LIBESMTP_NOTHREAD_IPK_DIR=$(BUILD_DIR)/libesmtp-nothread-$(LIBESMTP_NOTHREAD_VERSION)-ipk
LIBESMTP_NOTHREAD_IPK=$(BUILD_DIR)/libesmtp-nothread_$(LIBESMTP_NOTHREAD_VERSION)-$(LIBESMTP_NOTHREAD_IPK_VERSION)_$(TARGET_ARCH).ipk

.PHONY: libesmtp-nothread-source libesmtp-nothread-unpack libesmtp-nothread libesmtp-nothread-stage libesmtp-nothread-ipk libesmtp-nothread-clean libesmtp-nothread-dirclean libesmtp-nothread-check

#
# This is the dependency on the source code.  If the source is missing,
# then it will be fetched from the site using wget.
#
#$(DL_DIR)/$(LIBESMTP_NOTHREAD_SOURCE):
#	$(WGET) -P $(DL_DIR) $(LIBESMTP_NOTHREAD_SITE)/$(LIBESMTP_NOTHREAD_SOURCE)

#
# The source code depends on it existing within the download directory.
# This target will be called by the top level Makefile to download the
# source code's archive (.tar.gz, .bz2, etc.)
#
libesmtp-nothread-source: $(DL_DIR)/$(LIBESMTP_NOTHREAD_SOURCE) $(LIBESMTP_NOTHREAD_PATCHES)

#
# This target unpacks the source code in the build directory.
# If the source archive is not .tar.gz or .tar.bz2, then you will need
# to change the commands here.  Patches to the source code are also
# applied in this target as required.
#
# This target also configures the build within the build directory.
# Flags such as LDFLAGS and CPPFLAGS should be passed into configure
# and NOT $(MAKE) below.  Passing it to configure causes configure to
# correctly BUILD the Makefile with the right paths, where passing it
# to Make causes it to override the default search paths of the compiler.
#
# If the compilation of the package requires other packages to be staged
# first, then do that first (e.g. "$(MAKE) <bar>-stage <baz>-stage").
#
# If the package uses  GNU libtool, you should invoke $(PATCH_LIBTOOL) as
# shown below to make various patches to it.
#
$(LIBESMTP_NOTHREAD_BUILD_DIR)/.configured: $(DL_DIR)/$(LIBESMTP_NOTHREAD_SOURCE) $(LIBESMTP_NOTHREAD_PATCHES)
	$(MAKE) openssl-stage
	rm -rf $(BUILD_DIR)/$(LIBESMTP_NOTHREAD_DIR) $(LIBESMTP_NOTHREAD_BUILD_DIR)
	$(LIBESMTP_NOTHREAD_UNZIP) $(DL_DIR)/$(LIBESMTP_NOTHREAD_SOURCE) | tar -C $(BUILD_DIR) -xvf -
	#cat $(LIBESMTP_NOTHREAD_PATCHES) | patch -d $(BUILD_DIR)/$(LIBESMTP_NOTHREAD_DIR) -p1
	mv $(BUILD_DIR)/$(LIBESMTP_NOTHREAD_DIR) $(LIBESMTP_NOTHREAD_BUILD_DIR)
	(cd $(LIBESMTP_NOTHREAD_BUILD_DIR); \
		$(TARGET_CONFIGURE_OPTS) \
		CPPFLAGS="$(STAGING_CPPFLAGS) $(LIBESMTP_NOTHREAD_CPPFLAGS)" \
		LDFLAGS="$(STAGING_LDFLAGS) $(LIBESMTP_NOTHREAD_LDFLAGS)" \
		acx_working_snprintf=yes \
		./configure \
		--build=$(GNU_HOST_NAME) \
		--host=$(GNU_TARGET_NAME) \
		--target=$(GNU_TARGET_NAME) \
		--program-suffix=-nothread \
		--prefix=/opt \
		--disable-nls \
		--disable-pthreads \
	)
	touch $(LIBESMTP_NOTHREAD_BUILD_DIR)/.configured

libesmtp-nothread-unpack: $(LIBESMTP_NOTHREAD_BUILD_DIR)/.configured

#
# This builds the actual binary.
#
$(LIBESMTP_NOTHREAD_BUILD_DIR)/.built: $(LIBESMTP_NOTHREAD_BUILD_DIR)/.configured
	rm -f $(LIBESMTP_NOTHREAD_BUILD_DIR)/.built
	$(MAKE) -C $(LIBESMTP_NOTHREAD_BUILD_DIR)
	touch $(LIBESMTP_NOTHREAD_BUILD_DIR)/.built

#
# This is the build convenience target.
#
libesmtp-nothread: $(LIBESMTP_NOTHREAD_BUILD_DIR)/.built

#
# If you are building a library, then you need to stage it too.
#
$(LIBESMTP_NOTHREAD_BUILD_DIR)/.staged: $(LIBESMTP_NOTHREAD_BUILD_DIR)/.built
	rm -f $(LIBESMTP_NOTHREAD_BUILD_DIR)/.staged
	$(MAKE) -C $(LIBESMTP_NOTHREAD_BUILD_DIR) DESTDIR=$(STAGING_DIR) install
	sed -i -e 's|-I$${prefix}/include|-I$(STAGING_INCLUDE_DIR)|' $(STAGING_PREFIX)/bin/libesmtp-config-nothread
	sed -i -e 's|-L$${exec_prefix}/lib|-L$(STAGING_PREFIX)/lib|' $(STAGING_PREFIX)/bin/libesmtp-config-nothread
	ln -sf libesmtp-config-nothread $(STAGING_PREFIX)/bin/libesmtp-config
	touch $(LIBESMTP_NOTHREAD_BUILD_DIR)/.staged

libesmtp-nothread-stage: $(LIBESMTP_NOTHREAD_BUILD_DIR)/.staged

#
# This rule creates a control file for ipkg.  It is no longer
# necessary to create a seperate control file under sources/libesmtp-nothread
#
$(LIBESMTP_NOTHREAD_IPK_DIR)/CONTROL/control:
	@install -d $(@D)
	@rm -f $@
	@echo "Package: libesmtp-nothread" >>$@
	@echo "Architecture: $(TARGET_ARCH)" >>$@
	@echo "Priority: $(LIBESMTP_NOTHREAD_PRIORITY)" >>$@
	@echo "Section: $(LIBESMTP_NOTHREAD_SECTION)" >>$@
	@echo "Version: $(LIBESMTP_NOTHREAD_VERSION)-$(LIBESMTP_NOTHREAD_IPK_VERSION)" >>$@
	@echo "Maintainer: $(LIBESMTP_NOTHREAD_MAINTAINER)" >>$@
	@echo "Source: $(LIBESMTP_NOTHREAD_SITE)/$(LIBESMTP_NOTHREAD_SOURCE)" >>$@
	@echo "Description: $(LIBESMTP_NOTHREAD_DESCRIPTION)" >>$@
	@echo "Depends: $(LIBESMTP_NOTHREAD_DEPENDS)" >>$@
	@echo "Suggests: $(LIBESMTP_NOTHREAD_SUGGESTS)" >>$@
	@echo "Conflicts: $(LIBESMTP_NOTHREAD_CONFLICTS)" >>$@

#
# This builds the IPK file.
#
# Binaries should be installed into $(LIBESMTP_NOTHREAD_IPK_DIR)/opt/sbin or $(LIBESMTP_NOTHREAD_IPK_DIR)/opt/bin
# (use the location in a well-known Linux distro as a guide for choosing sbin or bin).
# Libraries and include files should be installed into $(LIBESMTP_NOTHREAD_IPK_DIR)/opt/{lib,include}
# Configuration files should be installed in $(LIBESMTP_NOTHREAD_IPK_DIR)/opt/etc/libesmtp-nothread/...
# Documentation files should be installed in $(LIBESMTP_NOTHREAD_IPK_DIR)/opt/doc/libesmtp-nothread/...
# Daemon startup scripts should be installed in $(LIBESMTP_NOTHREAD_IPK_DIR)/opt/etc/init.d/S??libesmtp-nothread
#
# You may need to patch your application to make it use these locations.
#
$(LIBESMTP_NOTHREAD_IPK): $(LIBESMTP_NOTHREAD_BUILD_DIR)/.built
	rm -rf $(LIBESMTP_NOTHREAD_IPK_DIR) $(BUILD_DIR)/libesmtp_*_$(TARGET_ARCH).ipk
	$(MAKE) -C $(LIBESMTP_NOTHREAD_BUILD_DIR) DESTDIR=$(LIBESMTP_NOTHREAD_IPK_DIR) install-strip
	rm -f `find $(LIBESMTP_NOTHREAD_IPK_DIR)/opt/lib -name '*.a'`
	install -d $(LIBESMTP_NOTHREAD_IPK_DIR)/opt/etc/
#	install -m 644 $(LIBESMTP_NOTHREAD_SOURCE_DIR)/libesmtp-nothread.conf $(LIBESMTP_NOTHREAD_IPK_DIR)/opt/etc/libesmtp-nothread.conf
#	install -d $(LIBESMTP_NOTHREAD_IPK_DIR)/opt/etc/init.d
#	install -m 755 $(LIBESMTP_NOTHREAD_SOURCE_DIR)/rc.libesmtp-nothread $(LIBESMTP_NOTHREAD_IPK_DIR)/opt/etc/init.d/SXXlibesmtp-nothread
#	sed -i -e '/^#!/aOPTWARE_TARGET=${OPTWARE_TARGET}' $(LIBESMTP_NOTHREAD_IPK_DIR)/opt/etc/init.d/SXXlibesmtp-nothread
	$(MAKE) $(LIBESMTP_NOTHREAD_IPK_DIR)/CONTROL/control
#	install -m 755 $(LIBESMTP_NOTHREAD_SOURCE_DIR)/postinst $(LIBESMTP_NOTHREAD_IPK_DIR)/CONTROL/postinst
#	sed -i -e '/^#!/aOPTWARE_TARGET=${OPTWARE_TARGET}' $(LIBESMTP_NOTHREAD_IPK_DIR)/CONTROL/postinst
#	install -m 755 $(LIBESMTP_NOTHREAD_SOURCE_DIR)/prerm $(LIBESMTP_NOTHREAD_IPK_DIR)/CONTROL/prerm
#	sed -i -e '/^#!/aOPTWARE_TARGET=${OPTWARE_TARGET}' $(LIBESMTP_NOTHREAD_IPK_DIR)/CONTROL/prerm
#	echo $(LIBESMTP_NOTHREAD_CONFFILES) | sed -e 's/ /\n/g' > $(LIBESMTP_NOTHREAD_IPK_DIR)/CONTROL/conffiles
	cd $(BUILD_DIR); $(IPKG_BUILD) $(LIBESMTP_NOTHREAD_IPK_DIR)

#
# This is called from the top level makefile to create the IPK file.
#
libesmtp-nothread-ipk: $(LIBESMTP_NOTHREAD_IPK)

#
# This is called from the top level makefile to clean all of the built files.
#
libesmtp-nothread-clean:
	rm -f $(LIBESMTP_NOTHREAD_BUILD_DIR)/.built
	-$(MAKE) -C $(LIBESMTP_NOTHREAD_BUILD_DIR) clean

#
# This is called from the top level makefile to clean all dynamically created
# directories.
#
libesmtp-nothread-dirclean:
	rm -rf $(BUILD_DIR)/$(LIBESMTP_NOTHREAD_DIR) $(LIBESMTP_NOTHREAD_BUILD_DIR) $(LIBESMTP_NOTHREAD_IPK_DIR) $(LIBESMTP_NOTHREAD_IPK)
#
#
# Some sanity check for the package.
#
libesmtp-nothread-check: $(LIBESMTP_NOTHREAD_IPK)
	perl scripts/optware-check-package.pl --target=$(OPTWARE_TARGET) $(LIBESMTP_NOTHREAD_IPK)
