###########################################################
#
# pthsem
#
###########################################################
#
# PTHSEM_VERSION, PTHSEM_SITE and PTHSEM_SOURCE define
# the upstream location of the source code for the package.
# PTHSEM_DIR is the directory which is created when the source
# archive is unpacked.
# PTHSEM_UNZIP is the command used to unzip the source.
# It is usually "zcat" (for .gz) or "bzcat" (for .bz2)
#
# You should change all these variables to suit your package.
# Please make sure that you add a description, and that you
# list all your packages' dependencies, seperated by commas.
# 
# If you list yourself as MAINTAINER, please give a valid email
# address, and indicate your irc nick if it cannot be easily deduced
# from your name or email address.  If you leave MAINTAINER set to
# "NSLU2 Linux" other developers will feel free to edit.
#
PTHSEM_SITE=http://$(SOURCEFORGE_MIRROR)/sourceforge/bcusdk
PTHSEM_VERSION=2.0.7
PTHSEM_SOURCE=pthsem_$(PTHSEM_VERSION).tar.gz
PTHSEM_DIR=pthsem-$(PTHSEM_VERSION)
PTHSEM_UNZIP=zcat
PTHSEM_MAINTAINER=NSLU2 Linux <nslu2-linux@yahoogroups.com>
PTHSEM_DESCRIPTION=An extend version of GNU pth, with support for semaphores added.
PTHSEM_SECTION=lib
PTHSEM_PRIORITY=optional
PTHSEM_DEPENDS=
PTHSEM_SUGGESTS=
PTHSEM_CONFLICTS=

#
# PTHSEM_IPK_VERSION should be incremented when the ipk changes.
#
PTHSEM_IPK_VERSION=1

#
# PTHSEM_CONFFILES should be a list of user-editable files
#PTHSEM_CONFFILES=/opt/etc/pthsem.conf /opt/etc/init.d/SXXpthsem

#
# PTHSEM_PATCHES should list any patches, in the the order in
# which they should be applied to the source code.
#
#PTHSEM_PATCHES=$(PTHSEM_SOURCE_DIR)/configure.patch

#
# If the compilation of the package requires additional
# compilation or linking flags, then list them here.
#
PTHSEM_CPPFLAGS=
PTHSEM_LDFLAGS=

#
# PTHSEM_BUILD_DIR is the directory in which the build is done.
# PTHSEM_SOURCE_DIR is the directory which holds all the
# patches and ipkg control files.
# PTHSEM_IPK_DIR is the directory in which the ipk is built.
# PTHSEM_IPK is the name of the resulting ipk files.
#
# You should not change any of these variables.
#
PTHSEM_BUILD_DIR=$(BUILD_DIR)/pthsem
PTHSEM_SOURCE_DIR=$(SOURCE_DIR)/pthsem
PTHSEM_IPK_DIR=$(BUILD_DIR)/pthsem-$(PTHSEM_VERSION)-ipk
PTHSEM_IPK=$(BUILD_DIR)/pthsem_$(PTHSEM_VERSION)-$(PTHSEM_IPK_VERSION)_$(TARGET_ARCH).ipk

.PHONY: pthsem-source pthsem-unpack pthsem pthsem-stage pthsem-ipk pthsem-clean pthsem-dirclean pthsem-check

#
# This is the dependency on the source code.  If the source is missing,
# then it will be fetched from the site using wget.
#
$(DL_DIR)/$(PTHSEM_SOURCE):
	$(WGET) -P $(DL_DIR) $(PTHSEM_SITE)/$(PTHSEM_SOURCE) || \
	$(WGET) -P $(DL_DIR) $(SOURCES_NLO_SITE)/$(PTHSEM_SOURCE)

#
# The source code depends on it existing within the download directory.
# This target will be called by the top level Makefile to download the
# source code's archive (.tar.gz, .bz2, etc.)
#
pthsem-source: $(DL_DIR)/$(PTHSEM_SOURCE) $(PTHSEM_PATCHES)

#
# This target unpacks the source code in the build directory.
# If the source archive is not .tar.gz or .tar.bz2, then you will need
# to change the commands here.  Patches to the source code are also
# applied in this target as required.
#
# This target also configures the build within the build directory.
# Flags such as LDFLAGS and CPPFLAGS should be passed into configure
# and NOT $(MAKE) below.  Passing it to configure causes configure to
# correctly BUILD the Makefile with the right paths, where passing it
# to Make causes it to override the default search paths of the compiler.
#
# If the compilation of the package requires other packages to be staged
# first, then do that first (e.g. "$(MAKE) <bar>-stage <baz>-stage").
#
# If the package uses  GNU libtool, you should invoke $(PATCH_LIBTOOL) as
# shown below to make various patches to it.
#
$(PTHSEM_BUILD_DIR)/.configured: $(DL_DIR)/$(PTHSEM_SOURCE) $(PTHSEM_PATCHES) make/pthsem.mk
#	$(MAKE) <bar>-stage <baz>-stage
	rm -rf $(BUILD_DIR)/$(PTHSEM_DIR) $(PTHSEM_BUILD_DIR)
	$(PTHSEM_UNZIP) $(DL_DIR)/$(PTHSEM_SOURCE) | tar -C $(BUILD_DIR) -xvf -
	if test -n "$(PTHSEM_PATCHES)" ; \
		then cat $(PTHSEM_PATCHES) | \
		patch -d $(BUILD_DIR)/$(PTHSEM_DIR) -p0 ; \
	fi
	if test "$(BUILD_DIR)/$(PTHSEM_DIR)" != "$(PTHSEM_BUILD_DIR)" ; \
		then mv $(BUILD_DIR)/$(PTHSEM_DIR) $(PTHSEM_BUILD_DIR) ; \
	fi
	(cd $(PTHSEM_BUILD_DIR); \
		$(TARGET_CONFIGURE_OPTS) \
		CPPFLAGS="$(STAGING_CPPFLAGS) $(PTHSEM_CPPFLAGS)" \
		LDFLAGS="$(STAGING_LDFLAGS) $(PTHSEM_LDFLAGS)" \
		./configure \
		--build=$(GNU_HOST_NAME) \
		--host=$(GNU_TARGET_NAME) \
		--target=$(GNU_TARGET_NAME) \
		--prefix=/opt \
		--disable-nls \
		--disable-static \
	)
	$(PATCH_LIBTOOL) $(PTHSEM_BUILD_DIR)/libtool
	touch $@

pthsem-unpack: $(PTHSEM_BUILD_DIR)/.configured

#
# This builds the actual binary.
#
$(PTHSEM_BUILD_DIR)/.built: $(PTHSEM_BUILD_DIR)/.configured
	rm -f $@
	$(MAKE) -C $(PTHSEM_BUILD_DIR)
	touch $@

#
# This is the build convenience target.
#
pthsem: $(PTHSEM_BUILD_DIR)/.built

#
# If you are building a library, then you need to stage it too.
#
$(PTHSEM_BUILD_DIR)/.staged: $(PTHSEM_BUILD_DIR)/.built
	rm -f $@
	$(MAKE) -C $(PTHSEM_BUILD_DIR) DESTDIR=$(STAGING_DIR) install
	touch $@

pthsem-stage: $(PTHSEM_BUILD_DIR)/.staged

#
# This rule creates a control file for ipkg.  It is no longer
# necessary to create a seperate control file under sources/pthsem
#
$(PTHSEM_IPK_DIR)/CONTROL/control:
	@install -d $(@D)
	@rm -f $@
	@echo "Package: pthsem" >>$@
	@echo "Architecture: $(TARGET_ARCH)" >>$@
	@echo "Priority: $(PTHSEM_PRIORITY)" >>$@
	@echo "Section: $(PTHSEM_SECTION)" >>$@
	@echo "Version: $(PTHSEM_VERSION)-$(PTHSEM_IPK_VERSION)" >>$@
	@echo "Maintainer: $(PTHSEM_MAINTAINER)" >>$@
	@echo "Source: $(PTHSEM_SITE)/$(PTHSEM_SOURCE)" >>$@
	@echo "Description: $(PTHSEM_DESCRIPTION)" >>$@
	@echo "Depends: $(PTHSEM_DEPENDS)" >>$@
	@echo "Suggests: $(PTHSEM_SUGGESTS)" >>$@
	@echo "Conflicts: $(PTHSEM_CONFLICTS)" >>$@

#
# This builds the IPK file.
#
# Binaries should be installed into $(PTHSEM_IPK_DIR)/opt/sbin or $(PTHSEM_IPK_DIR)/opt/bin
# (use the location in a well-known Linux distro as a guide for choosing sbin or bin).
# Libraries and include files should be installed into $(PTHSEM_IPK_DIR)/opt/{lib,include}
# Configuration files should be installed in $(PTHSEM_IPK_DIR)/opt/etc/pthsem/...
# Documentation files should be installed in $(PTHSEM_IPK_DIR)/opt/doc/pthsem/...
# Daemon startup scripts should be installed in $(PTHSEM_IPK_DIR)/opt/etc/init.d/S??pthsem
#
# You may need to patch your application to make it use these locations.
#
$(PTHSEM_IPK): $(PTHSEM_BUILD_DIR)/.built
	rm -rf $(PTHSEM_IPK_DIR) $(BUILD_DIR)/pthsem_*_$(TARGET_ARCH).ipk
	$(MAKE) -C $(PTHSEM_BUILD_DIR) DESTDIR=$(PTHSEM_IPK_DIR) install-strip

	rm -f $(PTHSEM_IPK_DIR)/opt/lib/libpthsem.a
	$(STRIP_COMMAND) $(PTHSEM_IPK_DIR)/opt/lib/libpthsem.so.*.*.*
	$(MAKE) $(PTHSEM_IPK_DIR)/CONTROL/control
	cd $(BUILD_DIR); $(IPKG_BUILD) $(PTHSEM_IPK_DIR)

#
# This is called from the top level makefile to create the IPK file.
#
pthsem-ipk: $(PTHSEM_IPK)

#
# This is called from the top level makefile to clean all of the built files.
#
pthsem-clean:
	rm -f $(PTHSEM_BUILD_DIR)/.built
	-$(MAKE) -C $(PTHSEM_BUILD_DIR) clean

#
# This is called from the top level makefile to clean all dynamically created
# directories.
#
pthsem-dirclean:
	rm -rf $(BUILD_DIR)/$(PTHSEM_DIR) $(PTHSEM_BUILD_DIR) $(PTHSEM_IPK_DIR) $(PTHSEM_IPK)
#
#
# Some sanity check for the package.
#
pthsem-check: $(PTHSEM_IPK)
	perl scripts/optware-check-package.pl --target=$(OPTWARE_TARGET) $(PTHSEM_IPK)
