###########################################################
#
# eibd
#
###########################################################
#
# EIBD_VERSION, EIBD_SITE and EIBD_SOURCE define
# the upstream location of the source code for the package.
# EIBD_DIR is the directory which is created when the source
# archive is unpacked.
# EIBD_UNZIP is the command used to unzip the source.
# It is usually "zcat" (for .gz) or "bzcat" (for .bz2)
#
# You should change all these variables to suit your package.
# Please make sure that you add a description, and that you
# list all your packages' dependencies, seperated by commas.
# 
# If you list yourself as MAINTAINER, please give a valid email
# address, and indicate your irc nick if it cannot be easily deduced
# from your name or email address.  If you leave MAINTAINER set to
# "NSLU2 Linux" other developers will feel free to edit.
#
EIBD_SITE=http://$(SOURCEFORGE_MIRROR)/sourceforge/bcusdk
EIBD_VERSION=0.0.3
EIBD_SOURCE=bcusdk_$(EIBD_VERSION).tar.gz
EIBD_DIR=bcusdk-$(EIBD_VERSION)
EIBD_UNZIP=zcat
EIBD_MAINTAINER=NSLU2 Linux <nslu2-linux@yahoogroups.com>
EIBD_DESCRIPTION=The eibd daemon is a central component of the BCU SDK. It provides an interface to the EIB/KNX bus.
EIBD_SECTION=util
EIBD_PRIORITY=optional
EIBD_DEPENDS=
EIBD_SUGGESTS=
EIBD_CONFLICTS=

#
# EIBD_IPK_VERSION should be incremented when the ipk changes.
#
EIBD_IPK_VERSION=5

#
# EIBD_CONFFILES should be a list of user-editable files
EIBD_CONFFILES=

#
# EIBD_PATCHES should list any patches, in the the order in
# which they should be applied to the source code.
#
EIBD_PATCHES=$(EIBD_SOURCE_DIR)/busmonitor-flush.patch

#
# If the compilation of the package requires additional
# compilation or linking flags, then list them here.
#
EIBD_CPPFLAGS=
EIBD_LDFLAGS=

#
# EIBD_BUILD_DIR is the directory in which the build is done.
# EIBD_SOURCE_DIR is the directory which holds all the
# patches and ipkg control files.
# EIBD_IPK_DIR is the directory in which the ipk is built.
# EIBD_IPK is the name of the resulting ipk files.
#
# You should not change any of these variables.
#
EIBD_BUILD_DIR=$(BUILD_DIR)/eibd
EIBD_SOURCE_DIR=$(SOURCE_DIR)/eibd
EIBD_IPK_DIR=$(BUILD_DIR)/eibd-$(EIBD_VERSION)-ipk
EIBD_IPK=$(BUILD_DIR)/eibd_$(EIBD_VERSION)-$(EIBD_IPK_VERSION)_$(TARGET_ARCH).ipk

.PHONY: eibd-source eibd-unpack eibd eibd-stage eibd-ipk eibd-clean eibd-dirclean eibd-check

#
# This is the dependency on the source code.  If the source is missing,
# then it will be fetched from the site using wget.
#
$(DL_DIR)/$(EIBD_SOURCE):
	$(WGET) -P $(DL_DIR) $(EIBD_SITE)/$(EIBD_SOURCE) || \
	$(WGET) -P $(DL_DIR) $(SOURCES_NLO_SITE)/$(EIBD_SOURCE)

#
# The source code depends on it existing within the download directory.
# This target will be called by the top level Makefile to download the
# source code's archive (.tar.gz, .bz2, etc.)
#
eibd-source: $(DL_DIR)/$(EIBD_SOURCE) $(EIBD_PATCHES)

#
# This target unpacks the source code in the build directory.
# If the source archive is not .tar.gz or .tar.bz2, then you will need
# to change the commands here.  Patches to the source code are also
# applied in this target as required.
#
# This target also configures the build within the build directory.
# Flags such as LDFLAGS and CPPFLAGS should be passed into configure
# and NOT $(MAKE) below.  Passing it to configure causes configure to
# correctly BUILD the Makefile with the right paths, where passing it
# to Make causes it to override the default search paths of the compiler.
#
# If the compilation of the package requires other packages to be staged
# first, then do that first (e.g. "$(MAKE) <bar>-stage <baz>-stage").
#
# If the package uses  GNU libtool, you should invoke $(PATCH_LIBTOOL) as
# shown below to make various patches to it.
#
$(EIBD_BUILD_DIR)/.configured: $(DL_DIR)/$(EIBD_SOURCE) $(EIBD_PATCHES) make/eibd.mk
	$(MAKE) pthsem-stage
	rm -rf $(BUILD_DIR)/$(EIBD_DIR) $(EIBD_BUILD_DIR)
	$(EIBD_UNZIP) $(DL_DIR)/$(EIBD_SOURCE) | tar -C $(BUILD_DIR) -xvf -
	if test -n "$(EIBD_PATCHES)" ; \
		then cat $(EIBD_PATCHES) | \
		patch -d $(BUILD_DIR)/$(EIBD_DIR) -p0 ; \
	fi
	if test "$(BUILD_DIR)/$(EIBD_DIR)" != "$(EIBD_BUILD_DIR)" ; \
		then mv $(BUILD_DIR)/$(EIBD_DIR) $(EIBD_BUILD_DIR) ; \
	fi
	(cd $(EIBD_BUILD_DIR); \
		$(TARGET_CONFIGURE_OPTS) \
		CPPFLAGS="$(STAGING_CPPFLAGS) $(EIBD_CPPFLAGS)" \
		LDFLAGS="$(STAGING_LDFLAGS) $(EIBD_LDFLAGS)" \
		./configure \
		--build=$(GNU_HOST_NAME) \
		--host=$(GNU_TARGET_NAME) \
		--target=$(GNU_TARGET_NAME) \
		--prefix=/opt \
		--disable-nls \
		--disable-static \
		--enable-onlyeibd \
		--enable-ft12 \
		--enable-eibnetip \
		--enable-eibnetiptunnel \
		--enable-eibnetipserver \
        --enable-usb \
		--without-pth-test \
	)
#	$(PATCH_LIBTOOL) $(EIBD_BUILD_DIR)/libtool
	touch $@

eibd-unpack: $(EIBD_BUILD_DIR)/.configured

#
# This builds the actual binary.
#
$(EIBD_BUILD_DIR)/.built: $(EIBD_BUILD_DIR)/.configured
	rm -f $@
	$(MAKE) -C $(EIBD_BUILD_DIR)
	touch $@

#
# This is the build convenience target.
#
eibd: $(EIBD_BUILD_DIR)/.built

#
# If you are building a library, then you need to stage it too.
#
$(EIBD_BUILD_DIR)/.staged: $(EIBD_BUILD_DIR)/.built
	rm -f $@
	$(MAKE) -C $(EIBD_BUILD_DIR) DESTDIR=$(STAGING_DIR) install
	touch $@

eibd-stage: $(EIBD_BUILD_DIR)/.staged

#
# This rule creates a control file for ipkg.  It is no longer
# necessary to create a seperate control file under sources/eibd
#
$(EIBD_IPK_DIR)/CONTROL/control:
	@install -d $(@D)
	@rm -f $@
	@echo "Package: eibd" >>$@
	@echo "Architecture: $(TARGET_ARCH)" >>$@
	@echo "Priority: $(EIBD_PRIORITY)" >>$@
	@echo "Section: $(EIBD_SECTION)" >>$@
	@echo "Version: $(EIBD_VERSION)-$(EIBD_IPK_VERSION)" >>$@
	@echo "Maintainer: $(EIBD_MAINTAINER)" >>$@
	@echo "Source: $(EIBD_SITE)/$(EIBD_SOURCE)" >>$@
	@echo "Description: $(EIBD_DESCRIPTION)" >>$@
	@echo "Depends: $(EIBD_DEPENDS)" >>$@
	@echo "Suggests: $(EIBD_SUGGESTS)" >>$@
	@echo "Conflicts: $(EIBD_CONFLICTS)" >>$@

#
# This builds the IPK file.
#
# Binaries should be installed into $(EIBD_IPK_DIR)/opt/sbin or $(EIBD_IPK_DIR)/opt/bin
# (use the location in a well-known Linux distro as a guide for choosing sbin or bin).
# Libraries and include files should be installed into $(EIBD_IPK_DIR)/opt/{lib,include}
# Configuration files should be installed in $(EIBD_IPK_DIR)/opt/etc/eibd/...
# Documentation files should be installed in $(EIBD_IPK_DIR)/opt/doc/eibd/...
# Daemon startup scripts should be installed in $(EIBD_IPK_DIR)/opt/etc/init.d/S??eibd
#
# You may need to patch your application to make it use these locations.
#
$(EIBD_IPK): $(EIBD_BUILD_DIR)/.built
	rm -rf $(EIBD_IPK_DIR) $(BUILD_DIR)/eibd_*_$(TARGET_ARCH).ipk
	$(MAKE) -C $(EIBD_BUILD_DIR) DESTDIR=$(EIBD_IPK_DIR) install-strip
	$(MAKE) $(EIBD_IPK_DIR)/CONTROL/control
	cd $(BUILD_DIR); $(IPKG_BUILD) $(EIBD_IPK_DIR)

#
# This is called from the top level makefile to create the IPK file.
#
eibd-ipk: $(EIBD_IPK)

#
# This is called from the top level makefile to clean all of the built files.
#
eibd-clean:
	rm -f $(EIBD_BUILD_DIR)/.built
	-$(MAKE) -C $(EIBD_BUILD_DIR) clean

#
# This is called from the top level makefile to clean all dynamically created
# directories.
#
eibd-dirclean:
	rm -rf $(BUILD_DIR)/$(EIBD_DIR) $(EIBD_BUILD_DIR) $(EIBD_IPK_DIR) $(EIBD_IPK)
#
#
# Some sanity check for the package.
#
eibd-check: $(EIBD_IPK)
	perl scripts/optware-check-package.pl --target=$(OPTWARE_TARGET) $(EIBD_IPK)
