function modifyCurrentZone()
{
	UIController.editZone();
}

function saveDesign()
{
	var version=prompt('Entrez un nom de version','design');
	if (version!=null)
	{
		UIController.saveDesign(version);
		$('#designVersion').val(version);
	}
}

function displayDesign()
{
	UIController.displayDesign();
}

function modifyBgImage()
{
		var design = UIController.getDesignName();
		$('#bgImages').empty().append($("<img src='images/loading.gif'/>"));
		req = jQuery.ajax({ type: 'post', url: 'design.php?action=filelist&name='+design, dataType: 'xml',
			success: function(responseXML, status) {
				$('#bgImages').empty();
				var xmlResponse = responseXML.documentElement;
				if (xmlResponse.getAttribute('status') != 'error') {
					$('file', responseXML).each(function() {
						var file = this.textContent;
						var re = new RegExp('\.(gif|jpe?g|png)$');
						if (re.test(file)) {
							var option = $("<img width='200' height='150' src='design/"+design+"/"+file+"' alt='"+file+"'/>");
							option.click(function () { setBackground(file); $('#changeImage').css('display', 'none'); });
							$('#bgImages').append(option);
						}
					});
				}
				else
					$('#bgImages').text("Unable to load images: "+xmlResponse.textContent);
			},
			error: function (XMLHttpRequest, textStatus, errorThrown) {
				$('#bgImages').text("Unable to load images: "+textStatus);
			}
		});
	
		$('#changeImage').css('left',(document.body.clientWidth/4)+'px').css('width',(document.body.clientWidth/2)+'px');
		$('#changeImage').css('display', 'block');
}

function setBackground(filename)
{
	if (filename!="")
	{
		UIController.changeZoneBackground($('#selectedZone').val(), filename);
	}
}

function newSwitchElement()
{
    var label = $('#newSwitchName').val();
	if (label!="")
	{
	    var conf = UIController.createControl('switch');
	    conf.setAttribute('label', label);
	    conf.setAttribute('object', $('#newSwitchCommandObject').val());
		UIController.add($('#selectedZone').val(), conf);
	} else alert('Vous devez spcifier un nom');
}

function newDimmerElement()
{
    var label = $('#newDimmerName').val();
	if (label!="")
	{
	    var conf = UIController.createControl('dimmer');
	    conf.setAttribute('label', label);
	    conf.setAttribute('dim', $('#newDimmerCommandObject').val());
	    conf.setAttribute('switch', $('#newDimmerOnOffObject').val());
	    conf.setAttribute('value', $('#newDimmerValueObject').val());
		UIController.add($('#selectedZone').val(), conf);
	} else alert('Vous devez spcifier un nom');
}

function newThermostatElement()
{
    var label = $('#newThermostatName').val();
	if (label!="")
	{
	    var conf = UIController.createControl('thermostat');
	    conf.setAttribute('label', label);
	    conf.setAttribute('mode', $('#newThermostatModeObject').val());
	    conf.setAttribute('setpoint', $('#newThermostatWTempObject').val());
	    conf.setAttribute('temp', $('#newThermostatTempObject').val());
		UIController.add($('#selectedZone').val(), conf);
	} else alert('Vous devez spcifier un nom');
}

function newGotoElement(img)
{
    var label = $('#newGotoName').val();
	if (label!="")
	{
	    var conf = UIController.createControl('goto');
	    conf.setAttribute('label', label);
	    conf.setAttribute('target', $('#newGotoZone').val());
//	    conf.setAttribute('img', $('#newGotoImage').val());
	    conf.setAttribute('img', img);
		UIController.add($('#selectedZone').val(), conf);
	} else alert('Vous devez spcifier un nom');
}

function newCameraElement()
{
    var label = $('#newCamName').val();
	if (label!="")
	{
	    var conf = UIController.createControl('camera');
	    conf.setAttribute('label', label);
	    conf.setAttribute('url', $('#newCamUrl').val());
		UIController.add($('#selectedZone').val(), conf);
	} else alert('Vous devez spcifier un nom');
}

function newTextElement(img)
{
    var label = $('#newTextString').val();
	if (label!="")
	{
	    var conf = UIController.createControl('text');
	    conf.setAttribute('label', label);
		UIController.add($('#selectedZone').val(), conf);
	} else alert('Vous devez spcifier le texte');
}

function addZone()
{
	var name=prompt('Entrez le nom de la nouvelle zone','');
	if (name!=null)	{
		UIController.addZone(name);
		var option = "<option value='"+name+"'>"+name+"</option>";
		$('#selectedZone').append($(option));
		$('#newGotoZone').append($(option));
		gotoZone(name, false);
	}
}

function delZone()
{
	if (confirm("Etes-vous sr de vouloir supprimer cette zone?")) {
    	var zone = $('#selectedZone');
    	UIController.removeZone(zone.val());
        zone.children(':selected').remove();
        UIController.drawZone(zone.val());
    }
}

function addDesign()
{
	var name=prompt('Entrez le nom du nouveau design','');
	if (name!=null) {
		req = jQuery.ajax({ type: 'post', url: 'design.php?action=createdesign&name='+name, dataType: 'xml',
			success: function(responseXML, status) {
				var xmlResponse = responseXML.documentElement;
				if (xmlResponse.getAttribute('status') != 'error') {
					var option = $("<option>"+name+"</option>");
					$('#designName').append(option);
					$('#designName').val(name);
					loadDesign(name, 'design');
				}
				else {
					UIController.setNotification("Unable to create design: "+xmlResponse.textContent);
				}
			},
			error: function (XMLHttpRequest, textStatus, errorThrown) {
				UIController.setNotification("Unable to create design: "+textStatus);
			}
		});
	}
}

function loadDesignList()
{
	req = jQuery.ajax({ url: 'design.php?action=designlist', dataType: 'xml',
		success: function(responseXML, status) {
			$('#designName').empty();
			var xmlResponse = responseXML.documentElement;
			if (xmlResponse.getAttribute('status') != 'error') {
				$('design', responseXML).each(function() {
					var option = $("<option>"+this.textContent+"</option>");
					$('#designName').append(option);
				});
				$('#designName').val(UIController.getDesignName());
			}
			else
				$('#designName').text("Unable to load design list: "+xmlResponse.textContent);
		},
		error: function (XMLHttpRequest, textStatus, errorThrown) {
			$('#designName').text("Unable to load design list: "+textStatus);
		}
	});
}

jQuery(function($) {
	loadDesignList();
	EIBCommunicator.loadObjectList();
});
