function CWidget(conf) {
}

CWidget.prototype = {
	getListeningObject: function() {
		return Array();
	},
	updateObject: function(obj,value) {
	},
	init: function(conf, style, width, height) {
		this.label=conf.getAttribute("label");
		this.conf=conf;
		var x = conf.getAttribute("x");
		var y = conf.getAttribute("y");
		if (!x) x = 190;
		if (!y) y = 20;
		div = $("<div class='"+style+"'/>");
		this.div = div.get(0);
		this.div.owner=this;
	
		// Create table
		table = $("<table class='"+style+"' cellpadding=0 cellspacing=0 />");
		tableBody = $("<tbody/>");
		
		// Create content
		table.append(tableBody);
		div.append(table);
		
		if (x) div.css('left', x+"px");
		if (y) div.css('top', y+"px");
		if (height) div.css('height', height);
		if (width) div.css('width', width);
		return tableBody;
	},
	edit: function(canMove, canClose) {
		var offset = 0;
		$('table tbody tr.editWidget', this.div).each(function() { $(this).remove(); offset = -15; });
		if (canMove || canClose) {
			offset += 15;
			var headerTr = $("<tr class='editWidget'/>");
			var header = $("<th align='right'/>");
			if (canClose) {
				var closeBtn = $("<img src='images/close.gif' style='cursor: pointer; margin-right: 2px;'/>").get(0);
				closeBtn.owner=this;
				closeBtn.onclick=function() { UIController.remove(this.owner); };
				header.append(closeBtn);
			}
			headerTr.append(header);
			$('table tbody', this.div).prepend(headerTr);
	
			if (canMove) {
				headerTr.css('cursor', 'move');
				Drag.init(headerTr.get(0),this.div);
				this.div.onDragEnd = function(x,y) {
					this.owner.conf.setAttribute('x', x);
					this.owner.conf.setAttribute('y', y+15);
				}
			}
		}
		if (offset != 0) {
			if (this.div.style.height)
				this.div.style.height = (parseInt(this.div.style.height, 10)+offset)+'px';
			this.div.style.top = (parseInt(this.div.style.top, 10)-offset)+'px';
		}
	}
}
