/*
    EIBD eib bus access and management daemon
    Copyright (C) 2005-2006 Martin K�gler <mkoegler@auto.tuwien.ac.at>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "objectcontroller.h"

ObjectController* ObjectController::instance_m;

Object::Object()
{
}

Object::~Object()
{
}

void Object::onUpdate()
{
}

void Object::addChangeListener(ChangeListener* listener)
{
    listenerList_m.push_back(listener);
}
void Object::removeChangeListener(ChangeListener* listener)
{
    listenerList_m.remove(listener);
}

SwitchingObject::SwitchingObject()
{
}

SwitchingObject::~SwitchingObject()
{
}

void SwitchingObject::setIntValue(int value)
{
    setBoolValue(value != 0);
}

void SwitchingObject::setFloatValue(float value)
{
    setBoolValue(value != 0);
}

void SwitchingObject::setBoolValue(bool value)
{
    if (value != value_m)
    {
        value_m = value;
//        backend_m->write(gad_m, value_m);
        onUpdate();
    }
}


ValueObject::ValueObject()
{
}

ValueObject::~ValueObject()
{
}

void ValueObject::setIntValue(int value)
{
    setFloatValue((float)value);
}

void ValueObject::setFloatValue(float value)
{
    if (value != value_m)
    {
        value_m = value;
//        backend_m->write(gad_m, value_m);
        onUpdate();
    }
}

void ValueObject::setBoolValue(bool value)
{
    setFloatValue(value ? 1 : 0);
}



ScalingObject::ScalingObject()
{
}

ScalingObject::~ScalingObject()
{
}

void ScalingObject::setIntValue(int value)
{
    if (value != value_m)
    {
        value_m = value;
//        backend_m->write(gad_m, value_m);
        onUpdate();
    }
}

void ScalingObject::setFloatValue(float value)
{
    setIntValue((int)value);
}

void ScalingObject::setBoolValue(bool value)
{
    setIntValue(value ? 1 : 0);
}


ObjectController::ObjectController()
{
}

ObjectController::~ObjectController()
{
}

ObjectController* ObjectController::instance()
{
  if (instance_m == 0)
    instance_m = new ObjectController();
  return instance_m;
}

Object* ObjectController::getObject(const std::string& id)
{
  return objectIdMap_m[id];
}

void ObjectController::importXml(ticpp::Element* pConfig)
{
}

void ObjectController::exportXml(ticpp::Element* pConfig)
{
}
